﻿//Transparent (CutOut) shader to be used on fences, teared cloth, flags, etc

Shader "!FullControl/Cutout/Cutout Advanced" 
{
	Properties 
	{
		//Diffuse Properties
		_MainColor ("Albedo Tint Color", Color) = (1, 1, 1, 1)
		_MainTex ("Albedo (RGB) | SpecMask (A)", 2D) = "grey" {}
		
		//Alpha
		_MainOp ("Opacity", 2D) = "white" {}
		_Cutoff ("Alpha cutoff", Range(0,1)) = 0.5
		
		//NormalMap Properties
		_BumpMap ("Normal Map", 2D) = "bump" {}
		
		//Specular Properties
		_SpecColor ("Spec Color", Color) = (1, 1, 1, 1)
		_SpecularPower ("Spec Power", Range (0.01, 20)) = 0.078125
		_SpecularIntensity ("Specular Intensity", float) = 6
		
		//RimLight Properties
		_RimLightColor ("RimLight Color", Color) = (1,1,1,1)
		_RimLightFalloff ("RimLight Fresnell", float) = 1 
		_RimLightIntensity ("RimLight Intensity", float) = 0.25
		
		//Reflection Properties
		_Cubemap ("Reflection Cubemap", CUBE) = "black" {}
		_ReflectionColor ("Reflection Color", Color) = (1,1,1,1)
		_ReflectionFalloff ("Reflection Fresnell", float) = 1 
		_ReflIntensity ("Reflection Intensity", float) = 0.25
		
		//Emission Properties
		_EmissionColor ("Emission Color", Color) = (0,0,0,0)
		_EmissionTex ("Emission Map", 2D) = "black" {}
		_EmissionInt ("Emission Intensity", float) = 0.0
	}
	
	SubShader 
	{
		Tags {"Queue"="AlphaTest" "IgnoreProjector" = "True"}
		
		LOD 400
		Cull Back
		CGPROGRAM
		#pragma target 3.0
		#pragma surface surf BlinnPhong addshadow alphatest:_Cutoff
		#pragma exclude_renderers flash
		
		//Diffuse
		float4 _MainColor;
		sampler2D _MainTex;
		sampler2D _BumpMap;
		
		//Alpha
		sampler2D _MainOp;
		
		//Specular
		float4 _SpecularColor;
		float _SpecularPower;
		float _SpecularIntensity;
		
		//RimLight
		float4 _RimLightColor;
		float _RimLightFalloff;
		float _RimLightIntensity;
		
		//Reflection
		samplerCUBE _Cubemap;
		float4 _ReflectionColor;
		float _ReflIntensity;
		float _ReflectionFalloff;
		
		//Emission
		sampler2D _EmissionTex;
		float4 _EmissionColor;
		float _EmissionInt;

		struct Input 
		{
			float2 uv_MainTex;
			float2 uv_MainOp;
			float3 worldRefl;
			float3 viewDir;
			INTERNAL_DATA
		};
		

		void surf (Input IN, inout SurfaceOutput o) 
		{
			//Diffuse
			half4 difTxt = tex2D (_MainTex, IN.uv_MainTex);
			half3 normalMap = UnpackNormal(tex2D(_BumpMap, IN.uv_MainOp));
			o.Normal = normalMap;
			
			//RimLight
			half rim = 1.0 - saturate(dot(o.Normal, normalize(IN.viewDir)));
			half3 finalRim = _RimLightColor.rgb * pow (rim, _RimLightFalloff) * _RimLightIntensity;
			
			//Reflection
			rim = pow(rim, _ReflectionFalloff);
			half3 finalRefl = texCUBE (_Cubemap, WorldReflectionVector (IN, o.Normal)).rgb * _ReflIntensity * rim * _ReflectionColor;
			
			//Emission
			half3 emissionTex = tex2D (_EmissionTex, IN.uv_MainTex);
			o.Emission = finalRefl * difTxt.a + finalRim + ((emissionTex + _EmissionColor) * _EmissionInt);
			
			//Specular
			o.Gloss = difTxt.a * _SpecularIntensity;
			o.Specular = _SpecularPower * (difTxt.a * 2);
			
			//Albedo			
			o.Albedo = difTxt.rgb * _MainColor;
			
			//Alpha
			o.Alpha = tex2D (_MainOp, IN.uv_MainOp);
			//o.Alpha = difTxt.a;
		}
		ENDCG
		
		Cull Front
		CGPROGRAM
		#pragma target 3.0
		#pragma surface surf BlinnPhong alphatest:_Cutoff
		#pragma exclude_renderers flash
		
		//Diffuse
		float4 _MainColor;
		sampler2D _MainTex;
		sampler2D _BumpMap;
		
		//Alpha
		sampler2D _MainOp;
		
		//Specular
		float4 _SpecularColor;
		float _SpecularPower;
		float _SpecularIntensity;
		
		//RimLight
		float4 _RimLightColor;
		float _RimLightFalloff;
		float _RimLightIntensity;
		
		//Reflection
		samplerCUBE _Cubemap;
		float4 _ReflectionColor;
		float _ReflIntensity;
		float _ReflectionFalloff;
		
		//Emission
		sampler2D _EmissionTex;
		float4 _EmissionColor;
		float _EmissionInt;

		struct Input 
		{
			float2 uv_MainTex;
			float2 uv_MainOp;
			float3 worldRefl;
			float3 viewDir;
			INTERNAL_DATA
		};
		

		void surf (Input IN, inout SurfaceOutput o) 
		{
			//Diffuse
			half4 difTxt = tex2D (_MainTex, IN.uv_MainTex);
			half3 normalMap = UnpackNormal(tex2D(_BumpMap, IN.uv_MainOp));
			o.Normal = -normalMap;
			
			//RimLight
			half rim = 1.0 - saturate(dot(o.Normal, normalize(IN.viewDir)));
			half3 finalRim = _RimLightColor.rgb * pow (rim, _RimLightFalloff) * _RimLightIntensity;
			
			//Reflection
			rim = pow(rim, _ReflectionFalloff);
			half3 finalRefl = texCUBE (_Cubemap, WorldReflectionVector (IN, o.Normal)).rgb * _ReflIntensity * rim * _ReflectionColor;
			
			//Emission
			half3 emissionTex = tex2D (_EmissionTex, IN.uv_MainTex);
			o.Emission = finalRefl * difTxt.a + finalRim + ((emissionTex + _EmissionColor) * _EmissionInt);
			
			//Specular
			o.Gloss = difTxt.a * _SpecularIntensity;
			o.Specular = _SpecularPower * (difTxt.a * 2);
			
			//Albedo			
			o.Albedo = difTxt.rgb * _MainColor;
			
			//Alpha
			o.Alpha = tex2D (_MainOp, IN.uv_MainOp);
			//o.Alpha = difTxt.a;
		}
		ENDCG
	}
	FallBack "Hidden/FallBack/Transparent/Transparent VertexLit - Alpha"
}
